<?php
/* --------------------------------------------------------------
   LanguageService.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Language;

use Gambio\Core\Language\Exceptions\LanguageNotFoundException;

/**
 * Interface LanguageService
 *
 * @package Gambio\Core\Language
 */
interface LanguageService
{
    /**
     * @return Languages
     */
    public function getAvailableLanguages(): Languages;
    
    
    /**
     * @return Languages
     */
    public function getAvailableAdminLanguages(): Languages;
    
    
    /**
     * @param int $id
     *
     * @return Language
     *
     * @throws LanguageNotFoundException
     */
    public function getLanguageById(int $id): Language;
    
    
    /**
     * @param string $code
     *
     * @return Language
     *
     * @throws LanguageNotFoundException
     */
    public function getLanguageByCode(string $code): Language;
}